CREATE DATABASE AgencjaArtystycznaZmiana CHARACTER SET utf8 COLLATE utf8_general_ci;

USE AgencjaArtystycznaZmiana;

CREATE TABLE Agenci (
        IDAgenta int NOT NULL AUTO_INCREMENT PRIMARY KEY,
        ImieAgenta nvarchar (25) NULL ,
        NazwiskoAgenta nvarchar (25) NULL ,
        AdresAgenta nvarchar (50) NULL ,
        MiastoAgenta nvarchar (30) NULL ,
        StanZamAgenta nvarchar (2) NULL ,
        KodPocztowyAgenta nvarchar (10) NULL ,
        TelefonAgenta nvarchar (15) NULL ,
        DataZatrudnienia date NULL ,
        Wynagrodzenie decimal(15, 2) NULL DEFAULT 0 ,
        Premia float(24) NULL 
);

CREATE TABLE Klienci (
	IDKlienta int NOT NULL AUTO_INCREMENT PRIMARY KEY,
	ImieKlienta nvarchar (25) NULL ,
	NazwiskoKlienta nvarchar (25) NULL ,
	AdresKlienta nvarchar (50) NULL ,
	MiastoKlienta nvarchar (30) NULL ,
	StanZamKlienta nvarchar (2) NULL ,
	KodPocztowyKlienta nvarchar (10) NULL ,
	TelefonKlienta nvarchar (15) NULL
);

CREATE TABLE Imprezy (
	NumerImprezy int NOT NULL AUTO_INCREMENT PRIMARY KEY,
	DzienRozpoczecia date NULL ,
	DzienZakonczenia date NULL ,
	GodzinaRozpoczecia time NULL ,
	GodzinaZakonczenia time NULL ,
	WartoscKontraktu decimal(15,2) NULL DEFAULT 0 ,
	IDKlienta int NULL DEFAULT 0 ,
	IDAgenta int NULL DEFAULT 0 ,
	IDWykonawcy int NULL DEFAULT 0 
);

CREATE TABLE Imprezy_archiwum (
	NumerImprezy int NOT NULL ,
	DzienRozpoczecia date NULL ,
	DzienZakonczenia date NULL ,
	GodzinaRozpoczecia time NULL ,
	GodzinaZakonczenia time NULL ,
	WartoscKontraktu decimal(15,2) NULL ,
	IDKlienta int NULL ,
	IDAgenta int NULL ,
	IDWykonawcy int NULL 
);

CREATE TABLE Czlonkowie_zespolu (
	IDWykonawcy int NOT NULL ,
	IDCzlonka int NOT NULL DEFAULT 0 ,
	Status smallint NULL DEFAULT 0 
);

CREATE TABLE Style_wykonawcow (
	IDWykonawcy int NOT NULL ,
	IDStylu int NOT NULL DEFAULT 0 
);

CREATE TABLE Wykonawcy (
	IDWykonawcy int NOT NULL AUTO_INCREMENT PRIMARY KEY,
	NazwaScenicznaWykonawcy nvarchar (50) NULL ,
	NrUbezpWykonawcy nvarchar (12) NULL ,
	AdresWykonawcy nvarchar (50) NULL ,
	MiastoWykonawcy nvarchar (30) NULL ,
	StanZamWykonawcy nvarchar (2) NULL ,
	KodPocztowyWykonawcy nvarchar (10) NULL ,
	TelefonWykonawcy nvarchar (15) NULL ,
	StronaInterWykonawcy nvarchar (50) NULL ,
	EmailWykonawcy nvarchar (50) NULL ,
	DataRejestracji date NULL ,
	StawkaDziennaWykonawcy decimal(15,2) NULL 
);

CREATE TABLE Czlonkowie (
	IDCzlonka int NOT NULL AUTO_INCREMENT PRIMARY KEY,
	ImieCzlonka nvarchar (25) NULL ,
	NazwiskoCzlonka nvarchar (25) NULL ,
	TelefonCzlonka nvarchar (15) NULL ,
	Plec nvarchar (2) NULL 
);

CREATE TABLE Gusty_muzyczne (
	IDKlienta int NOT NULL DEFAULT 0 ,
	IDStylu int NOT NULL DEFAULT 0 
);

CREATE TABLE Style_muzyczne (
	IDStylu int NOT NULL AUTO_INCREMENT PRIMARY KEY,
	NazwaStylu nvarchar (75) NULL 
);

CREATE  INDEX KodPocztowyAgenta ON Agenci(KodPocztowyAgenta);

CREATE  INDEX KodPocztowyKlienta ON Klienci(KodPocztowyKlienta);

CREATE  INDEX AgenciImprezy ON Imprezy(IDAgenta);

CREATE  INDEX IDKlienta ON Imprezy(IDKlienta);

CREATE  INDEX IDPracownika ON Imprezy(IDAgenta);

CREATE  INDEX IDWykonawcy ON Imprezy(IDWykonawcy);

ALTER TABLE Imprezy_archiwum 
        ADD CONSTRAINT Imprezy_archiwum_PK PRIMARY KEY 
        (
                NumerImprezy
        );

CREATE  INDEX IDKlienta ON Imprezy_archiwum(IDKlienta);

CREATE  INDEX IDPracownika ON Imprezy_archiwum(IDAgenta);

CREATE  INDEX IDWykonawcy ON Imprezy_archiwum(IDWykonawcy);

ALTER TABLE Czlonkowie_zespolu 
        ADD CONSTRAINT Czlonkowie_zespolu_PK PRIMARY KEY 
        (
                IDWykonawcy, 
                IDCzlonka
        );

CREATE  INDEX WykonawcyCzlonkowie_zespolu ON Czlonkowie_zespolu(IDWykonawcy);

CREATE  INDEX CzlonkowieCzlonkowie_zespolu ON Czlonkowie_zespolu(IDCzlonka);

ALTER TABLE Style_wykonawcow 
        ADD CONSTRAINT Style_wykonawcow_PK PRIMARY KEY 
        (
                IDWykonawcy, 
                IDStylu
        );

CREATE  INDEX WykonawcyStyle_wykonawcow ON Style_wykonawcow(IDWykonawcy);

CREATE  INDEX Musical_StylesEntertainer_Styles ON Style_wykonawcow(IDStylu);

CREATE  INDEX KodPocztowyWykonawcy ON Wykonawcy(KodPocztowyWykonawcy);

ALTER TABLE Gusty_muzyczne 
        ADD CONSTRAINT Gusty_muzyczne_PK PRIMARY KEY 
        (
                IDKlienta, 
                IDStylu
        );

CREATE  INDEX IDKlienta ON Gusty_muzyczne(IDKlienta);

CREATE  INDEX IDStylu ON Gusty_muzyczne(IDStylu);

ALTER TABLE Imprezy 
        ADD CONSTRAINT Imprezy_FK00 FOREIGN KEY 
        (
                IDAgenta
        ) REFERENCES Agenci (
                IDAgenta
        ),
        ADD CONSTRAINT Imprezy_FK01 FOREIGN KEY 
        (
                IDKlienta
        ) REFERENCES Klienci (
                IDKlienta
        ),
        ADD CONSTRAINT Imprezy_FK02 FOREIGN KEY 
        (
               IDWykonawcy
        ) REFERENCES Wykonawcy (
               IDWykonawcy
        );

ALTER TABLE Czlonkowie_zespolu 
        ADD CONSTRAINT Czlonkowie_zespolu_FK00 FOREIGN KEY 
        (
                IDWykonawcy
        ) REFERENCES Wykonawcy (
                IDWykonawcy
        ),
        ADD CONSTRAINT Czlonkowie_zespolu_FK01 FOREIGN KEY 
        (
                IDCzlonka
        ) REFERENCES Czlonkowie (
                IDCzlonka
        );

ALTER TABLE Style_wykonawcow 
        ADD CONSTRAINT Style_wykonawcow_FK00 FOREIGN KEY 
        (
                IDWykonawcy
        ) REFERENCES Wykonawcy (
                IDWykonawcy
        ),
        ADD CONSTRAINT Style_wykonawcow_FK01 FOREIGN KEY 
        (
                IDStylu
        ) REFERENCES Style_muzyczne 
        (
                IDStylu
        );

ALTER TABLE Gusty_muzyczne 
        ADD CONSTRAINT Gusty_muzyczne_FK00 FOREIGN KEY 
        (
                IDKlienta
        ) REFERENCES Klienci (
                IDKlienta
        ),
        ADD CONSTRAINT Gusty_muzyczne_FK01 FOREIGN KEY 
        (
                IDStylu
        ) REFERENCES Style_muzyczne (
                IDStylu
        );